#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>
#include <queue>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

const int MAXN = 32768;
const int kN = 20 * 1000;
const int kInf = 2100 * 1000 * 1000;

vector<int> g[kN];
vector<int> path[kN];
vector<int> f[kN];

struct Edge {
  int from, to, w, id;

  Edge(int from_ = 0, int to_ = 0, int w_ = 0, int id_ = 0) : from(from_), to(to_), w(w_), id(id_) {}
};

vector<Edge> edges;

void Dijkstra(int n) {
  vector<int> dist(n, kInf);
  dist[0] = 0;
  priority_queue<pii> pq;
  pq.push(pii(0, 0));
  while (!pq.empty()) {
    auto p = pq.top();
    pq.pop();
    if (dist[p.second] != -p.first) {
      continue;
    }
    int u = p.second;
    int d = -p.first;
    for (int i = 0; i < g[u].size(); ++i) {
      Edge edge = edges[g[u][i]];
      int v = edge.to;
      int w = edge.w;
      if (d + w < dist[v]) {
        path[v].clear();
        path[v].push_back(g[u][i]);
        dist[v] = d + w;
        pq.push(pii(-dist[v], v));
      } else if (d + w == dist[v]) {
        path[v].push_back(g[u][i]);
      } 
    }
  }
}

vector<int> tin;
vector<int> fup;
vector<char> used;
int timer = 0;

map<pii, int> cnt;
int res = 0;
int finish;
vector <int> answer;

bool DFS(int v, int parent) {
  used[v] = true;
  tin[v] = timer++;
  fup[v] = tin[v];
  bool ok = v == finish;
  for (int i = 0; i < f[v].size(); ++i) {
    Edge edge = edges[f[v][i]];
    int to = edge.to;
    if (!used[to]) {
      bool curr = DFS(to, edge.id);
      if (curr) {
        ok = true;
      }
      fup[v] = min(fup[v], fup[to]);
      if (fup[to] > tin[v] && curr) {
        answer.push_back(edge.id);
      }
    } else if (edge.id != parent) {
      fup[v] = min(fup[v], tin[to]);
    }
  }
  return ok;
}

int main() {
  std::ios_base::sync_with_stdio(false);
  int n, m;
  cin >> n >> m;
  finish = n - 1;
  for (int i = 0; i < m; ++i) {
    int u, v, w;
    cin >> u >> v >> w; --u; --v;
    edges.push_back(Edge(u, v, w, i + 1));
    g[u].push_back((int)edges.size() - 1);
    edges.push_back(Edge(v, u, w, i + 1));
    g[v].push_back((int)edges.size() - 1);
  }
  Dijkstra(n);
  for (int u = 0; u < n; ++u) {
    for (int i = 0; i < path[u].size(); ++i) {
      Edge edge = edges[path[u][i]];
      f[edge.from].push_back(path[u][i]);
      f[u].push_back(path[u][i] ^ 1);
    }
  }
  tin.resize(n);
  fup.resize(n);
  used.resize(n);
  DFS(0, -1);

  cout << answer.size() << '\n';
  for (int i = 0; i != answer.size(); ++i) {
    cout << answer[i] << ' ';
  }

  return 0;
}